/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tasks;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.servlet.tasks.ContentManager;
import com.ibm.hwmca.fw.servlet.util.HMCCustomScope;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.AWPage;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WContainer;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.psw.wcl.core.trigger.ITriggerManager;
import com.ibm.psw.wcl.core.trigger.RequestNotHandledException;
import com.ibm.psw.wcl.core.trigger.TriggerException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class TaskInterface
extends HttpServlet {
    private static final String TRACE_MASKT = "XTIFSRVT";
    private static final String TRACE_MASKF = "XTIFSRVF";
    private static final String TRACE_MASKD = "XTIFSRVD";
    private static final String TASK_RESOURCE_BUNDLE = "com.ibm.hwmca.fw.servlet.tasks.res.task";
    private static final String LOGOFF_TASK_CLASS = "com.ibm.hwmca.base.logoff.LogoffApp";
    private static final String PICS_LABEL = "'(pics-1.1 \"http://www.icra.org/ratingsv02.html\" comment \"ICRAonline EN v2.0\" l r (nz 1 vz 1 lz 1 oz 1 cz 1) \"http://www.rsac.org/ratingsv01.html\" l r (n 0 s 0 v 0 l 0))'";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Processing URI " + req.getRequestURI());
        PanelModelTaskPortal affectedTask = null;
        try {
            IResult triggerResult;
            boolean needTransactionReleaseCall;
            boolean needFailedTriggerCall;
            PanelModel affectedPanelModel;
            HMCSession hmcSession;
            block62: {
                block61: {
                    ServletContext context = this.getServletContext();
                    String servletPath = req.getServletPath();
                    ServletRuntime.getRuntime().attachUserContextToServletThread(req);
                    hmcSession = HMCSession.getHMCSession(req.getSession());
                    ContentManager contentManager = ContentManager.getContentManager(hmcSession);
                    if (servletPath.equals("/content")) {
                        String taskId = req.getParameter("taskId");
                        if (taskId != null) {
                            affectedTask = hmcSession.getPanelModelTaskPortal(taskId);
                            if (affectedTask == null) {
                                this.badRequest(req, resp, "unknownTaskIdError", new Object[]{taskId, "/content"});
                                return;
                            }
                        } else {
                            String windowName = req.getParameter("windowName");
                            if (windowName == null) {
                                this.badRequest(req, resp, "invalidContentURLError");
                                return;
                            }
                            affectedTask = hmcSession.getTaskForWindowName(windowName);
                            if (affectedTask == null) {
                                this.badRequest(req, resp, "unknownWindowNameError", new Object[]{windowName});
                                return;
                            }
                        }
                        try {
                            contentManager.prepareForRendering();
                        }
                        catch (HException e) {
                            throw new ServletException("Exception preparing WCL for rendering", (Throwable)e);
                        }
                        affectedTask.acknowledgeRefreshes();
                        this.respondWithCurrentPage(req, resp, affectedTask, hmcSession);
                        return;
                    }
                    if (servletPath.equals("/task")) {
                        String operation = req.getParameter("op");
                        if (operation == null) {
                            this.badRequest(req, resp, "invalidTaskMissingOpError");
                            return;
                        }
                        String taskId = req.getParameter("taskId");
                        if (taskId != null) {
                            affectedTask = hmcSession.getPanelModelTaskPortal(taskId);
                            if (affectedTask == null) {
                                this.badRequest(req, resp, "unknownTaskIdError", new Object[]{taskId, "/task"});
                                return;
                            }
                            affectedTask.associatePortalWithCurrentThread();
                            affectedTask.acknowledgeRefreshes();
                        }
                        if (operation.equals("windowclose")) {
                            if (taskId == null) {
                                this.badRequest(req, resp, "invalidTaskMissingTaskError");
                                return;
                            }
                            Trace.trace(TRACE_MASKT, "Window for task id " + taskId + " was closed.");
                            affectedTask.windowClosed();
                            PrintWriter out = resp.getWriter();
                            resp.setContentType("text/html");
                            out.write("<html><head><title>Task Window Closed</title></head>\n");
                            out.write("<body><script type=\"text/javascript\">window.close();</script>");
                            out.print("</body></html>");
                            return;
                        }
                        if (operation.equals("mainwindowclose")) {
                            Trace.trace(TRACE_MASKT, "Main user interface window was closed.");
                            this.processMainWindowClose(req, resp, hmcSession);
                            return;
                        }
                        this.badRequest(req, resp, "unknownOperationError", new Object[]{operation});
                        return;
                    }
                    affectedPanelModel = null;
                    needFailedTriggerCall = false;
                    needTransactionReleaseCall = false;
                    try {
                        try {
                            WclFacade facade = contentManager.getWclFacade();
                            if (facade == null) {
                                this.badRequest(req, resp, "unrecognizedURIError");
                                Object var23_30 = null;
                                if (needTransactionReleaseCall) {
                                    affectedPanelModel.getImplAccess().releaseTransactionLock();
                                }
                                if (!needFailedTriggerCall) return;
                                affectedTask.failedTriggerManager(affectedPanelModel);
                                return;
                            }
                            TriggerContext triggerContext = facade.createTriggerContext(req, context);
                            RenderingContext renderingContext = facade.createRenderingContext(req, resp, context);
                            ITriggerManager triggerManager = facade.getTriggerManager((AContext)triggerContext);
                            WComponent wComponent = triggerManager.getTargetComponent(triggerContext);
                            Trace.trace(TRACE_MASKF, "Target WCL component is of type " + (wComponent != null ? wComponent.getClass().getName() : " null"));
                            WContainer topContainer = this.findTopContainer(wComponent);
                            if (topContainer instanceof AWPage) {
                                String pageName = ((AWPage)topContainer).getPageName();
                                Trace.trace(TRACE_MASKF, "Affected page is \"" + pageName + "\"");
                                Object scope = context.getAttribute(pageName);
                                if (scope instanceof HMCCustomScope) {
                                    affectedPanelModel = (PanelModel)((HMCCustomScope)scope).getAttachment();
                                    affectedTask = affectedPanelModel.getImplAccess().getPanelModelTaskPortal();
                                    Trace.trace(TRACE_MASKT, "Affected task is " + affectedTask.getTaskId());
                                }
                            }
                            if (affectedTask != null) {
                                block60: {
                                    try {
                                        affectedTask.acknowledgeRefreshes();
                                        PanelModel topPanel = affectedTask.getCurrentPanelModel();
                                        if (affectedPanelModel == topPanel) break block60;
                                        String taskURI = req.getContextPath() + "/content?taskId=" + affectedTask.getTaskId();
                                        req.setAttribute("taskURI", (Object)taskURI);
                                        req.setAttribute("expectedWindowName", (Object)affectedTask.getWindowName());
                                        Trace.trace(TRACE_MASKF, "Dispatching request to historyWarning.jsp");
                                        req.getRequestDispatcher("/tasks/historyWarning.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                                        break block61;
                                    }
                                    catch (TaskEndedException e) {
                                        this.closeTaskWindow(req, resp, affectedTask, hmcSession);
                                        Object var23_32 = null;
                                        if (needTransactionReleaseCall) {
                                            affectedPanelModel.getImplAccess().releaseTransactionLock();
                                        }
                                        if (!needFailedTriggerCall) return;
                                        affectedTask.failedTriggerManager(affectedPanelModel);
                                        return;
                                    }
                                }
                                String windowPosition = req.getParameter("hmcWindowPosition");
                                if (windowPosition != null) {
                                    try {
                                        int comma = windowPosition.indexOf(44);
                                        if (comma != -1 && comma > 0 && comma < windowPosition.length() - 1) {
                                            int x = Integer.parseInt(windowPosition.substring(0, comma));
                                            int y = Integer.parseInt(windowPosition.substring(comma + 1));
                                            Trace.trace(TRACE_MASKF, "Setting window position for task with id " + affectedTask.getTaskId() + " to " + x + ',' + y);
                                            TaskWindowPositionManager.getTaskWindowPositionManager(hmcSession).windowMovedTo(affectedTask, x, y);
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                }
                                Trace.trace(TRACE_MASKF, "Calling PanelModelTaskPortal.preTriggerManager()");
                                affectedTask.preTriggerManager(affectedPanelModel);
                                needFailedTriggerCall = true;
                                affectedPanelModel.getImplAccess().obtainTransactionLock();
                                needTransactionReleaseCall = true;
                            }
                            Trace.trace(TRACE_MASKT, "Passing URI to Trigger Manager");
                            triggerResult = triggerManager.handleRequest(triggerContext, renderingContext);
                            if (affectedTask != null) {
                                Trace.trace(TRACE_MASKF, "Calling PanelModelTaskPortal.postTriggerManager()");
                                affectedPanelModel.getImplAccess().releaseTransactionLock();
                                needTransactionReleaseCall = false;
                                affectedTask.postTriggerManager(affectedPanelModel);
                                needFailedTriggerCall = false;
                            }
                            break block62;
                        }
                        catch (RequestNotHandledException e) {
                            if (needTransactionReleaseCall) {
                                affectedPanelModel.getImplAccess().releaseTransactionLock();
                                needTransactionReleaseCall = false;
                            }
                            if (needFailedTriggerCall) {
                                affectedTask.failedTriggerManager(affectedPanelModel);
                                needFailedTriggerCall = false;
                            }
                            if (affectedTask != null) {
                                String taskURI = req.getContextPath() + "/content?taskId=" + affectedTask.getTaskId();
                                req.setAttribute("taskURI", (Object)taskURI);
                                req.setAttribute("expectedWindowName", (Object)affectedTask.getWindowName());
                                Trace.trace(TRACE_MASKF, "Trigger Manager rejected request.  Dispatching request to historyWarning.jsp");
                                req.getRequestDispatcher("/tasks/historyWarning.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                            } else {
                                Trace.trace(TRACE_MASKF, "Trigger Manager rejected request.  Dispatching request to correctPanel.jsp");
                                req.getRequestDispatcher("/tasks/correctPanel.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                            }
                            Object var23_34 = null;
                            if (needTransactionReleaseCall) {
                                affectedPanelModel.getImplAccess().releaseTransactionLock();
                            }
                            if (!needFailedTriggerCall) return;
                            affectedTask.failedTriggerManager(affectedPanelModel);
                            return;
                        }
                        catch (TriggerException e) {
                            throw new ServletException("Exception while processing WCL trigger for URI: " + req.getRequestURI(), (Throwable)e);
                        }
                        catch (Exception e) {
                            throw new ServletException("Exception while processing WCL trigger for URI: " + req.getRequestURI(), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var23_35 = null;
                        if (needTransactionReleaseCall) {
                            affectedPanelModel.getImplAccess().releaseTransactionLock();
                        }
                        if (!needFailedTriggerCall) throw throwable;
                        affectedTask.failedTriggerManager(affectedPanelModel);
                        throw throwable;
                    }
                }
                Object var23_31 = null;
                if (needTransactionReleaseCall) {
                    affectedPanelModel.getImplAccess().releaseTransactionLock();
                }
                if (!needFailedTriggerCall) return;
                affectedTask.failedTriggerManager(affectedPanelModel);
                return;
            }
            Object var23_33 = null;
            if (needTransactionReleaseCall) {
                affectedPanelModel.getImplAccess().releaseTransactionLock();
            }
            if (needFailedTriggerCall) {
                affectedTask.failedTriggerManager(affectedPanelModel);
            }
            if (triggerResult.isResponseHandled()) {
                Trace.trace(TRACE_MASKT, "Response handled by trigger manager.  Returning.");
                return;
            }
            if (affectedTask != null) {
                Trace.trace(TRACE_MASKT, "Response not handled by trigger manager.  Rendering current page for task " + affectedTask.getTaskId());
                this.respondWithCurrentPage(req, resp, affectedTask, hmcSession);
                return;
            }
            Trace.trace(TRACE_MASKF, "Response not handled by trigger manager for unknown task.  Dispatching request to correctPanel.jsp");
            req.getRequestDispatcher("/tasks/correctPanel.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "Ignoring an I/O Exception while rendering panel for task " + (affectedTask != null ? affectedTask.getTaskId() : "(unknown)") + ": " + e);
            throw e;
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKT, "Exception while rendering panel for task " + (affectedTask != null ? affectedTask.getTaskId() : "(unknown)"));
            Trace.trace(TRACE_MASKT, e);
            if (affectedTask == null) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (!(e instanceof ServletException)) return;
                throw (ServletException)e;
            }
            String details = null;
            Throwable exc = e;
            StringWriter buffer = new StringWriter();
            PrintWriter stack = new PrintWriter(buffer);
            exc.printStackTrace(stack);
            while (exc != null) {
                if (exc instanceof ServletException) {
                    exc = ((ServletException)exc).getRootCause();
                } else if (exc instanceof JspException) {
                    exc = ((JspException)exc).getRootCause();
                } else {
                    if (!(exc instanceof TriggerException)) break;
                    exc = ((TriggerException)exc).getNestedException();
                }
                if (exc == null) continue;
                stack.println();
                stack.println("Caused by:");
                exc.printStackTrace(stack);
            }
            stack.flush();
            details = buffer.toString();
            FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "ClientTaskError");
            FrameworkLog logEntry = new FrameworkLog(logInfo, 72, e);
            logEntry.add(details);
            logEntry.log(FrameworkLogAttributes.INFO_LOG);
            PresentationTask presentationTask = affectedTask.getPresentationTask();
            presentationTask.logException(e);
            req.setAttribute("details", (Object)this.escapeForHTMLDocument(details));
            Trace.trace(TRACE_MASKF, "Dispatching request to showError.jsp");
            RequestDispatcher dispatcher = req.getRequestDispatcher("/tasks/showError.jsp");
            try {
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (IllegalStateException ee) {
                dispatcher.include((ServletRequest)req, (ServletResponse)resp);
            }
            affectedTask.setRefreshEnabled(false);
            presentationTask.forceTaskToTerminate("Exception encountered while rendering panel as HTML");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void respondWithCurrentPage(HttpServletRequest req, HttpServletResponse resp, PanelModelTaskPortal task, HMCSession hmcSession) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "Serving current page for task " + task.getTaskId());
        resp.addHeader("Cache-Control", "no-cache");
        if (req.getProtocol().equals("HTTP/1.0")) {
            resp.addHeader("Pragma", "no-cache");
        }
        PanelModel currentPage = null;
        try {
            block12: {
                try {
                    currentPage = task.getCurrentPanelModelAndLock();
                    if (currentPage != null) {
                        task.getContentManager().renderContent(currentPage, (Servlet)this, this.getServletContext(), req, resp);
                        break block12;
                    }
                    String redirectURL = task.getRedirectURL();
                    if (redirectURL != null) {
                        Trace.trace(TRACE_MASKT, "Redirecting task to URL: " + redirectURL);
                        resp.sendRedirect(resp.encodeRedirectURL(redirectURL));
                        break block12;
                    }
                    this.closeTaskWindow(req, resp, task, hmcSession);
                }
                catch (TaskEndedException e) {
                    String redirectURL = task.getRedirectURL();
                    if (redirectURL != null) {
                        Trace.trace(TRACE_MASKT, "Redirecting task to URL: " + redirectURL);
                        resp.sendRedirect(resp.encodeRedirectURL(redirectURL));
                    } else {
                        this.closeTaskWindow(req, resp, task, hmcSession);
                    }
                    Object var9_9 = null;
                    if (currentPage != null) {
                        currentPage.getImplAccess().releaseTransactionLock();
                    }
                }
            }
            Object var9_8 = null;
            if (currentPage != null) {
                currentPage.getImplAccess().releaseTransactionLock();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (currentPage != null) {
                currentPage.getImplAccess().releaseTransactionLock();
            }
            throw throwable;
        }
    }

    private void closeTaskWindow(HttpServletRequest req, HttpServletResponse resp, PanelModelTaskPortal task, HMCSession hmcSession) throws ServletException, IOException {
        if (hmcSession.isDisconnected()) {
            ArrayList<String> windowNames = new ArrayList<String>();
            windowNames.add(hmcSession.getWindowPrefix() + "hmcuimainwin");
            Iterator iterator = hmcSession.getKnownTasks().iterator();
            while (iterator.hasNext()) {
                PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
                if (portal == task || !portal.isWindowOpen()) continue;
                windowNames.add(portal.getWindowName());
                portal.setWindowOpen(false);
            }
            req.setAttribute("windowNames", windowNames);
        }
        task.setWindowOpen(false);
        Trace.trace(TRACE_MASKF, "Window closed.  Dispatching request to closeWindow.jsp");
        req.getRequestDispatcher("/tasks/closeWindow.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected WContainer findTopContainer(WComponent component) {
        WContainer parent;
        while (component != null && !(component instanceof AWPage) && (parent = component.getParent()) != null) {
            component = parent;
        }
        return component instanceof WContainer ? (WContainer)component : null;
    }

    private String escapeForHTMLDocument(String details) {
        StringBuffer output = new StringBuffer(details.length() + 30);
        int len = details.length();
        boolean lastCharIsCR = false;
        for (int i = 0; i < len; ++i) {
            char c = details.charAt(i);
            switch (c) {
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\n': {
                    if (!lastCharIsCR) {
                        output.append("\\r");
                    }
                    output.append("\\n");
                    break;
                }
                case '\"': {
                    output.append("\\\"");
                    break;
                }
                case '\\': {
                    output.append("\\\\");
                    break;
                }
                default: {
                    output.append(c);
                }
            }
            lastCharIsCR = c == '\r';
        }
        return output.toString();
    }

    private void processMainWindowClose(HttpServletRequest req, HttpServletResponse resp, HMCSession hmcSession) throws IOException {
        hmcSession.userClosedMainUIWindow();
        Trace.trace(TRACE_MASKT, "Starting LogoffApp to have user choose to logoff or disconnect.");
        try {
            PresentationTaskParms parms = new PresentationTaskParms();
            parms.setData("mode", "mainwindowclosed");
            parms.setData("windowname", req.getParameter("windowname"));
            PresentationTask task = TaskLauncher.startTask(parms, LOGOFF_TASK_CLASS, hmcSession, false);
            PanelModelTaskPortal portal = task.getPanelModelTaskPortal();
            Trace.trace(TRACE_MASKT, "TaskInterface waiting for LogoffApp to prepare first panel.");
            portal.waitForPanel();
            if (portal.isTaskEnded()) {
                Trace.trace(TRACE_MASKT, "LogoffApp ended without showing a panel.");
                resp.sendRedirect(resp.encodeRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/connect?option=closeWindow"));
                return;
            }
            Trace.trace(TRACE_MASKT, "Redirecting LogoffApp to Task Interface for task id == " + task.getTaskId());
            resp.sendRedirect(resp.encodeRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/content?taskId=" + task.getTaskId()));
            return;
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            Trace.trace(TRACE_MASKT, "Exception running LogoffApp.");
            Trace.trace(TRACE_MASKT, e);
            resp.sendRedirect(resp.encodeRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/connect?option=closeWindow"));
            return;
        }
    }

    private void badRequest(HttpServletRequest req, HttpServletResponse resp, String messageKey) throws ServletException, IOException {
        this.badRequest(req, resp, messageKey, null);
    }

    protected void badRequest(HttpServletRequest req, HttpServletResponse resp, String messageKey, Object[] substitutionData) throws ServletException, IOException {
        ResourceBundle resources = ResourceBundle.getBundle(TASK_RESOURCE_BUNDLE, req.getLocale());
        String messagePattern = resources.getString(messageKey);
        MessageFormat message = new MessageFormat(messagePattern, req.getLocale());
        String finalMessage = message.format(substitutionData, new StringBuffer(), (FieldPosition)null).toString();
        req.setAttribute("errorMessage", (Object)finalMessage);
        Trace.trace(TRACE_MASKF, "Dispatching request to badRequest.jsp");
        req.getRequestDispatcher("/tasks/badRequest.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

